PROGRAM IOs
VAR
diTemp						: DINT ;
iURV, iTemp					: INT ;
rTemp						: REAL ;
END_VAR
IF module_ready THEN															(* m24 is started up *)
	Fresh_Air_Temperature_Measurement 					:= GetNtc10MeasurementF   (InputNumber:=1) ;
	Supply_Air_Temperature_Measurement 					:= GetNtc10MeasurementF   (InputNumber:=2) ;
	Return_Air_Temperature_Measurement					:= GetVoltageMeasurementF (InputNumber:=3, minVoltage:=0.0, maxVoltage:=10.0, minValue:=0.0, maxValue:=50.0) ;
	Return_Air_CO2_Measurement							:= GetVoltageMeasurementF (InputNumber:=4, minVoltage:=0.0, maxVoltage:=10.0, minValue:=0.0, maxValue:=2000.0) ;
	Exhaust_Air_Temperature_Measurement					:= GetNtc10MeasurementF   (InputNumber:=5) ;
	Heating_Coil_Return_Water_Temperature_Measurement	:= GetPt1000MeasurementF  (InputNumber:=6) ;

	diTemp := GetAnalogInputF (InputNumber:=7);
	IF 		diTemp=1 THEN 	Fresh_Air_Damper_Position	:=OPENED;		
	ELSE 					Fresh_Air_Damper_Position	:=CLOSED; 		END_IF ;

	diTemp := GetAnalogInputF (InputNumber:=8);
	IF 		diTemp=1 THEN 	Exhaust_Air_Damper_Position	:=OPENED;		
	ELSE 					Exhaust_Air_Damper_Position	:=CLOSED; 		END_IF ;

	diTemp := GetAnalogInputF (InputNumber:=9);
	IF 		diTemp=1 THEN 	Fresh_Air_Filter			:=DIRTY;		
	ELSE 					Fresh_Air_Filter			:=CLEAN; 		END_IF ;

	diTemp := GetAnalogInputF (InputNumber:=10);
	IF 		diTemp=1 THEN 	Return_Air_Filter			:=DIRTY;		
	ELSE 					Return_Air_Filter			:=CLEAN; 		END_IF ;

	diTemp := GetAnalogInputF (InputNumber:=11);
	IF 		diTemp=1 THEN 	Supply_Fan_Status			:=RUNNING;		
	ELSE 					Supply_Fan_Status			:=NOT_RUNNING; 	END_IF ;

	diTemp := GetAnalogInputF (InputNumber:=12);
	IF 		diTemp=1 THEN 	Return_Fan_Status			:=RUNNING;		
	ELSE 					Return_Fan_Status			:=NOT_RUNNING; 	END_IF ;

	IF Fresh_Air_Damper_Control=OPEN 	THEN iTemp:=1; ELSE iTemp:=0; END_IF ;		iURV := SetDigitalOutputF (RelayNumber:=1, value:=iTemp);
	IF Exhaust_Air_Damper_Control=OPEN 	THEN iTemp:=1; ELSE iTemp:=0; END_IF ;		iURV := SetDigitalOutputF (RelayNumber:=2, value:=iTemp);
	IF HRU_Control=RUN 					THEN iTemp:=1; ELSE iTemp:=0; END_IF ;		iURV := SetDigitalOutputF (RelayNumber:=3, value:=iTemp);
	IF Cooling_Coil_Pump_Control=RUN 	THEN iTemp:=1; ELSE iTemp:=0; END_IF ;		iURV := SetDigitalOutputF (RelayNumber:=4, value:=iTemp);
	
	iURV  := SetAnalogOutputF (AnalogOutputNumber:=1, value:=Supply_Fan_Speed_Control  );
	iURV  := SetAnalogOutputF (AnalogOutputNumber:=2, value:=Return_Fan_Speed_Control  );
	iURV  := SetAnalogOutputF (AnalogOutputNumber:=3, value:=Heating_Coil_Valve_Control);
	iURV  := SetAnalogOutputF (AnalogOutputNumber:=4, value:=Cooling_Coil_Valve_Control);
	
	IF Supply_Fan_Command=RUN THEN rTemp:=100.0; ELSE rTemp:=0.0; END_IF ; 			iURV := SetAnalogOutputF (AnalogOutputNumber:=5, value:=rTemp);
	IF Return_Fan_Command=RUN THEN rTemp:=100.0; ELSE rTemp:=0.0; END_IF ; 			iURV := SetAnalogOutputF (AnalogOutputNumber:=6, value:=rTemp);

END_IF ;
END_PROGRAM